#include <stdio.h>

#include <mpi.h>

int main (int argc, char ** argv)
{
  int size, rank, rlen;
  char myname[MPI_MAX_PROCESSOR_NAME]; 

  MPI_Init (&argc, &argv);

  MPI_Comm_size (MPI_COMM_WORLD, &size);
  
  MPI_Comm_rank (MPI_COMM_WORLD, &rank);

  MPI_Get_processor_name (myname, &rlen);

  fprintf (stdout, "I am proces %3d of %3d my name is %s (%s)\n", 
    rank, size, myname, argv[0]);

  if (size == 2) {
    if (rank == 0) {
      int val = 10;
      MPI_Send (&val, 1, MPI_INT, 1, 1, MPI_COMM_WORLD);
    }
    else {
      int myval;
      MPI_Status status;
      MPI_Recv (&myval, 1, MPI_INT, 0, 1, MPI_COMM_WORLD, &status);
      fprintf (stdout, "I am %s and I recv: %d\n", myname, myval);
    }
  }
  
  MPI_Finalize ();
 
  return 0;
} 
